package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.ClaseCentroTrabajo;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ClaseCentroTrabajoDaoImpl generated by UDA, 27-dic-2016 12:43:15.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ClaseCentroTrabajoDaoImpl implements ClaseCentroTrabajoDao {

	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.CLASCTR_072 CLASCTR072, t1.DESCLAS_EU_072 DESCLASEU072, t1.DESCLAS_ES_072 DESCLASES072, t1.FECBAJ_072 FECBAJ072 FROM AB0472S00 t1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ClaseCentroTrabajo> rwMap = new RowMapper<ClaseCentroTrabajo>() {
		public ClaseCentroTrabajo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ClaseCentroTrabajo(resultSet.getString("CLASCTR072"), resultSet.getString("DESCLASEU072"),
					resultSet.getString("DESCLASES072"), resultSet.getDate("FECBAJ072"));
		}
	};

	private RowMapper<ClaseCentroTrabajo> rwMapPK = new RowMapper<ClaseCentroTrabajo>() {
		public ClaseCentroTrabajo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ClaseCentroTrabajo(resultSet.getString("CLASCTR072"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	public ClaseCentroTrabajo add(ClaseCentroTrabajo claseCentroTrabajo) {
		
		Long claseCentroTrabajoPK = Secuencias.CLASES_CENTROS.getNextLong(this.jdbcTemplate);
		if (claseCentroTrabajoPK != null) {
			claseCentroTrabajo.setClasctr072(claseCentroTrabajoPK.toString());
		}
		
		String query = "INSERT INTO AB0472S00 (CLASCTR_072, DESCLAS_EU_072, DESCLAS_ES_072, FECBAJ_072) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, claseCentroTrabajo.getClasctr072(), claseCentroTrabajo.getDesclasEu072(),
				claseCentroTrabajo.getDesclasEs072(), claseCentroTrabajo.getFecbaj072());
		return claseCentroTrabajo;
	}

	/**
	 * Updates a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	public ClaseCentroTrabajo update(ClaseCentroTrabajo claseCentroTrabajo) {
		String query = "UPDATE AB0472S00 SET DESCLAS_EU_072=?, DESCLAS_ES_072=?, FECBAJ_072=? WHERE CLASCTR_072=? ";
		this.jdbcTemplate.update(query, claseCentroTrabajo.getDesclasEu072(), claseCentroTrabajo.getDesclasEs072(),
				claseCentroTrabajo.getFecbaj072(), claseCentroTrabajo.getClasctr072());
		return claseCentroTrabajo;
	}

	/**
	 * Finds a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the clase centro trabajo
	 */
	@Transactional(readOnly = true)
	public ClaseCentroTrabajo find(ClaseCentroTrabajo claseCentroTrabajo) {
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CLASCTR_072 = ? ");

		List<ClaseCentroTrabajo> claseCentroTrabajoList = this.jdbcTemplate.query(query.toString(), this.rwMap,
				claseCentroTrabajo.getClasctr072());
		return (ClaseCentroTrabajo) DataAccessUtils.uniqueResult(claseCentroTrabajoList);
	}

	/**
	 * Removes a single row in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo            ClaseCentroTrabajo
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 */
	public void remove(ClaseCentroTrabajo claseCentroTrabajo) {
		String query = "DELETE FROM AB0472S00 WHERE CLASCTR_072=?";
		this.jdbcTemplate.update(query, claseCentroTrabajo.getClasctr072());
	}

	/**
	 * Finds a list of rows in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<ClaseCentroTrabajo>
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ClaseCentroTrabajo> findAll(ClaseCentroTrabajo claseCentroTrabajo, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(claseCentroTrabajo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ClaseCentroTrabajo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b72s00 table using like.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<ClaseCentroTrabajo>
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ClaseCentroTrabajo> findAllLike(ClaseCentroTrabajo claseCentroTrabajo, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(claseCentroTrabajo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ClaseCentroTrabajo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b72s00 table.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  Long
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ClaseCentroTrabajo claseCentroTrabajo) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0472S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(claseCentroTrabajo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab04b72s00 table using like.
	 * 
	 *  claseCentroTrabajo
	 *            ClaseCentroTrabajo
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ClaseCentroTrabajo claseCentroTrabajo, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0472S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(claseCentroTrabajo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b72s00 selected for rup_table.
	 * 
	 *  claseCentroTrabajo            ClaseCentroTrabajo
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<ClaseCentroTrabajo>>
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ClaseCentroTrabajo>> reorderSelection(ClaseCentroTrabajo claseCentroTrabajo,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(claseCentroTrabajo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto,
				ClaseCentroTrabajo.class, filterParamList, "CLASCTR072");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ClaseCentroTrabajo>(this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            ClaseCentroTrabajo
	 *  searchParams            ClaseCentroTrabajo
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<ClaseCentroTrabajo>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ClaseCentroTrabajo>> search(ClaseCentroTrabajo filterParams,
			ClaseCentroTrabajo searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto,
				ClaseCentroTrabajo.class, filterParamList, searchSQL, searchParamList, from_alias,
				"CLASCTR072");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ClaseCentroTrabajo>(this.rwMapPK, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterClaseCentroTrabajo            ClaseCentroTrabajo
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterClaseCentroTrabajo the filter clase centro trabajo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override()
	public void removeMultiple(ClaseCentroTrabajo filterClaseCentroTrabajo, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(ClaseCentroTrabajoDaoImpl.QUERY_SELECT);
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterClaseCentroTrabajo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto,
				ClaseCentroTrabajo.class, query, params, "CLASCTR072");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ClaseCentroTrabajo entity.
	 * 
	 *  claseCentroTrabajo            ClaseCentroTrabajo Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ClaseCentroTrabajo claseCentroTrabajo) {

		StringBuilder where = new StringBuilder(ClaseCentroTrabajoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (claseCentroTrabajo != null && claseCentroTrabajo.getClasctr072() != null) {
			where.append(" AND t1.CLASCTR_072 = ?");
			params.add(claseCentroTrabajo.getClasctr072());
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getDesclasEu072() != null) {
			where.append(" AND t1.DESCLAS_EU_072 = ?");
			params.add(claseCentroTrabajo.getDesclasEu072());
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getDesclasEs072() != null) {
			where.append(" AND t1.DESCLAS_ES_072 = ?");
			params.add(claseCentroTrabajo.getDesclasEs072());
		}
		where.append(" AND (t1.FECBAJ_072 IS NULL OR t1.FECBAJ_072 > SYSDATE)");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ClaseCentroTrabajo entity.
	 * 
	 *  claseCentroTrabajo            ClaseCentroTrabajo Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param claseCentroTrabajo the clase centro trabajo
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(ClaseCentroTrabajo claseCentroTrabajo, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ClaseCentroTrabajoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (claseCentroTrabajo != null && claseCentroTrabajo.getClasctr072() != null) {
			where.append(" AND UPPER(t1.CLASCTR_072) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseCentroTrabajo.getClasctr072().toUpperCase() + "%");
			} else {
				params.add("%" + claseCentroTrabajo.getClasctr072().toUpperCase() + "%");
			}
			where.append(" AND t1.CLASCTR_072 IS NOT NULL");
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getDesclasEu072() != null) {
			where.append(" AND UPPER(t1.DESCLAS_EU_072) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseCentroTrabajo.getDesclasEu072().toUpperCase() + "%");
			} else {
				params.add("%" + claseCentroTrabajo.getDesclasEu072().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCLAS_EU_072 IS NOT NULL");
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getDesclasEs072() != null) {
			where.append(" AND UPPER(t1.DESCLAS_ES_072) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(claseCentroTrabajo.getDesclasEs072().toUpperCase() + "%");
			} else {
				params.add("%" + claseCentroTrabajo.getDesclasEs072().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCLAS_ES_072 IS NOT NULL");
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getFecbajaDesde() != null) {
			where.append(" AND t1.FECBAJ_072 >= ?");
			params.add(claseCentroTrabajo.getFecbajaDesde());
		}
		if (claseCentroTrabajo != null && claseCentroTrabajo.getFecbajaHasta() != null) {
			where.append(" AND t1.FECBAJ_072 <= ?");
			params.add(claseCentroTrabajo.getFecbajaHasta());
		}
		if(claseCentroTrabajo != null && claseCentroTrabajo.getFecbajaDesde() == null && claseCentroTrabajo.getFecbajaHasta() == null){
			where.append(" AND (t1.FECBAJ_072 IS NULL OR t1.FECBAJ_072 > SYSDATE)");
		}
		
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
